<?php
/**
 * Customizer Controls Configs.
 *
 * @package Boldgrid_Theme_Framework
 * @subpackage Boldgrid_Theme_Framework\Configs\Customizer\Controls
 *
 * @since 2.0.0
 *
 * @return array Controls to create in the WordPress Customizer.
 */
return array(
	'bgtfw_pages_container'                => array(
		'settings'          => 'bgtfw_pages_container',
		'transport'         => 'refresh',
		'label'             => esc_html__( 'Container', 'crio' ),
		'type'              => 'radio-buttonset',
		'priority'          => 35,
		'default'           => 'container',
		'choices'           => array(
			'container'      => '<span class="icon-layout-container"></span>' . esc_attr__( 'Contained', 'crio' ),
			''               => '<span class="icon-layout-full-screen"></span>' . esc_attr__( 'Full Width', 'crio' ),
			'max-full-width' => '<span class="icon-layout-max-full-width"></span>' . esc_attr__( 'Max Full Width', 'crio' ),
		),
		'section'           => 'bgtfw_layout_page_container',
		'sanitize_callback' => function( $value, $settings ) {
			$sanitized_value = $settings->default;
			switch ( $value ) {
				case '':
					$sanitized_value = '';
					break;
				case 'container':
					$sanitized_value = 'container';
					break;
				case 'max-full-width':
					$sanitized_value = 'max-full-width';
					break;
				default:
					$sanitized_value = $settings->default;
					break;
			}

			return $sanitized_value;
		},
		'js_vars'           => array(
			array(
				'element'       => '.page .site-content',
				'function'      => 'html',
				'attr'          => 'class',
				'value_pattern' => 'site-content $',
			),
			array(
				'element'       => 'body.page',
				'function'      => 'html',
				'attr'          => 'data-container',
				'value_pattern' => '$',
			),
		),
		'edit_vars'         => array(
			array(
				'selector'    => '.page .site-content',
				'label'       => __( 'Page Layout', 'crio' ),
				'description' => __( 'Choose between contained or full-width page layout', 'crio' ),
			),
		),
	),
	'bgtfw_blog_page_container'            => array(
		'settings'          => 'bgtfw_blog_page_container',
		'transport'         => 'refresh',
		'label'             => esc_html__( 'Container', 'crio' ),
		'type'              => 'radio-buttonset',
		'priority'          => 35,
		'default'           => 'container',
		'choices'           => array(
			'container'      => '<span class="icon-layout-container"></span>' . esc_attr__( 'Contained', 'crio' ),
			''               => '<span class="icon-layout-full-screen"></span>' . esc_attr__( 'Full Width', 'crio' ),
			'max-full-width' => '<span class="icon-layout-max-full-width"></span>' . esc_attr__( 'Max Full Width', 'crio' ),
		),
		'section'           => 'bgtfw_pages_blog_blog_page_post_content',
		'sanitize_callback' => function( $value, $settings ) {
			$sanitized_value = $settings->default;
			switch ( $value ) {
				case '':
					$sanitized_value = '';
					break;
				case 'container':
					$sanitized_value = 'container';
					break;
				case 'max-full-width':
					$sanitized_value = 'max-full-width';
					break;
				default:
					$sanitized_value = $settings->default;
					break;
			}

			return $sanitized_value;
		},
	),
	'bgtfw_blog_posts_container'           => array(
		'settings'          => 'bgtfw_blog_posts_container',
		'transport'         => 'refresh',
		'label'             => esc_html__( 'Container', 'crio' ),
		'tooltip'           => __( 'Choose if you would like your content wrapped in a container or cover the full width of the page.', 'crio' ),
		'type'              => 'radio-buttonset',
		'priority'          => 40,
		'default'           => 'container',
		'choices'           => array(
			'container'      => '<span class="icon-layout-container"></span>' . esc_attr__( 'Contained', 'crio' ),
			''               => '<span class="icon-layout-full-screen"></span>' . esc_attr__( 'Full Width', 'crio' ),
			'max-full-width' => '<span class="icon-layout-max-full-width"></span>' . esc_attr__( 'Max Full Width', 'crio' ),
		),
		'section'           => 'bgtfw_pages_blog_posts_container',
		'sanitize_callback' => function( $value, $settings ) {
			$sanitized_value = $settings->default;
			switch ( $value ) {
				case '':
					$sanitized_value = '';
					break;
				case 'container':
					$sanitized_value = 'container';
					break;
				case 'max-full-width':
					$sanitized_value = 'max-full-width';
					break;
				default:
					$sanitized_value = $settings->default;
					break;
			}

			return $sanitized_value;
		},
		'js_vars'           => array(
			array(
				'element'       => '.single-post .main-wrapper',
				'function'      => 'html',
				'attr'          => 'class',
				'value_pattern' => 'main-wrapper $',
			),
		),
	),
	'bgtfw_woocommerce_container'          => array(
		'settings'          => 'bgtfw_woocommerce_container',
		'transport'         => 'postMessage',
		'label'             => esc_html__( 'Container', 'crio' ),
		'type'              => 'radio-buttonset',
		'priority'          => 35,
		'default'           => 'container',
		'choices'           => array(
			'container'      => '<span class="icon-layout-container"></span>' . esc_attr__( 'Contained', 'crio' ),
			''               => '<span class="icon-layout-full-screen"></span>' . esc_attr__( 'Full Width', 'crio' ),
			'max-full-width' => '<span class="icon-layout-max-full-width"></span>' . esc_attr__( 'Max Full Width', 'crio' ),
		),
		'section'           => 'bgtfw_layout_woocommerce_container',
		'sanitize_callback' => function( $value, $settings ) {
			$sanitized_value = $settings->default;
			switch ( $value ) {
				case '':
					$sanitized_value = '';
					break;
				case 'container':
					$sanitized_value = 'container';
					break;
				case 'max-full-width':
					$sanitized_value = 'max-full-width';
					break;
				default:
					$sanitized_value = $settings->default;
					break;
			}

			return $sanitized_value;
		},
		'js_vars'           => array(
			array(
				'element'       => '.woocommerce .site-content, .woocommerce-page .site-content',
				'function'      => 'html',
				'attr'          => 'class',
				'value_pattern' => 'site-content $',
			),
			array(
				'element'       => '.woocommerce .main-wrapper, .woocommerce-page .main-wrapper',
				'function'      => 'html',
				'attr'          => 'class',
				'value_pattern' => 'main-wrapper $',
			),
			array(
				'element'       => '.woocommerce-page .main > .container, .woocommerce-page .main > .full-width',
				'function'      => 'html',
				'attr'          => 'class',
				'value_pattern' => '$',
			),
		),
		'edit_vars'         => array(
			array(
				'selector'    => '.woocommerce .site-content',
				'label'       => __( 'WooCommerce Page Layout', 'crio' ),
				'description' => __( 'Choose between contained or full-width page layout for WooCommerce pages', 'crio' ),
			),
		),
	),
	'bgtfw_pages_container_max_width'      => array(
		'type'              => 'kirki-generic',
		'transport'         => 'postMessage',
		'section'           => 'bgtfw_layout_page_container',
		'settings'          => 'bgtfw_pages_container_max_width',
		'label'             => 'Container Max Width',
		'default'           => $bgtfw_generic->get_width_defaults( 'max-width' ),
		'priority'          => 36,
		'sanitize_callback' => array( 'Boldgrid_Framework_Customizer_Generic', 'sanitize' ),
		'active_callback'   => array(
			array(
				'setting'  => 'bgtfw_pages_container',
				'operator' => '===',
				'value'    => 'max-full-width',
			),
		),
		'choices'           => array(
			'name'     => 'boldgrid_controls',
			'type'     => 'ContainerWidth',
			'settings' => array(
				'responsive' => array(
					'tablet'  => 991,
					'desktop' => 1199,
				),
				'control'    => array(
					'selectors' => array(
						'body.page .container-fluid',
						'body.page .boldgrid-section > .full-width',
						'body.page .page-header-wrapper.full-width .featured-imgage-header:not( .container )',
					),
					'title'     => 'Container Max Width',
					'name'      => 'bgtfw_pages_container_max_width',
					'sliders'   => array(
						array(
							'name'        => 'maxWidth',
							'label'       => '',
							'cssProperty' => 'max-width',
						),
					),
					'units'     => array(
						'default' => 'px',
						'enabled' => array( 'px' ),
					),
				),
			),
		),
	),
	'bgtfw_blog_page_container_max_width'  => array(
		'type'              => 'kirki-generic',
		'transport'         => 'postMessage',
		'section'           => 'bgtfw_pages_blog_blog_page_post_content',
		'settings'          => 'bgtfw_blog_page_container_max_width',
		'label'             => 'Container Max Width',
		'default'           => $bgtfw_generic->get_width_defaults( 'max-width' ),
		'priority'          => 37,
		'sanitize_callback' => array( 'Boldgrid_Framework_Customizer_Generic', 'sanitize' ),
		'active_callback'   => array(
			array(
				'setting'  => 'bgtfw_blog_page_container',
				'operator' => '===',
				'value'    => 'max-full-width',
			),
		),
		'choices'           => array(
			'name'     => 'boldgrid_controls',
			'type'     => 'ContainerWidth',
			'settings' => array(
				'responsive' => array(
					'tablet'  => 991,
					'desktop' => 1199,
				),
				'control'    => array(
					'selectors' => array(
						'body.blog .container-fluid',
						'body.archive .container-fluid',
						'body.blog .boldgrid-section > .full-width',
						'body.archive .boldgrid-section > .full-width',
						'body.blog #main-wrapper.full-width.max-full-width',
						'body.archive #main-wrapper.full-width.max-full-width',
						'body.blog .page-header-wrapper.full-width .featured-imgage-header:not( .container )',
						'body.archive .page-header-wrapper.full-width .featured-imgage-header:not( .container )',
					),
					'title'     => 'Container Max Width',
					'name'      => 'bgtfw_blog_page_container_max_width',
					'sliders'   => array(
						array(
							'name'        => 'maxWidth',
							'label'       => '',
							'cssProperty' => 'max-width',
						),
					),
					'units'     => array(
						'default' => 'px',
						'enabled' => array( 'px' ),
					),
				),
			),
		),
	),
	'bgtfw_blog_posts_container_max_width' => array(
		'type'              => 'kirki-generic',
		'transport'         => 'postMessage',
		'section'           => 'bgtfw_pages_blog_posts_container',
		'settings'          => 'bgtfw_blog_posts_container_max_width',
		'label'             => 'Container Max Width',
		'default'           => $bgtfw_generic->get_width_defaults( 'max-width' ),
		'priority'          => 40,
		'sanitize_callback' => array( 'Boldgrid_Framework_Customizer_Generic', 'sanitize' ),
		'active_callback'   => array(
			array(
				'setting'  => 'bgtfw_blog_posts_container',
				'operator' => '===',
				'value'    => 'max-full-width',
			),
		),
		'choices'           => array(
			'name'     => 'boldgrid_controls',
			'type'     => 'ContainerWidth',
			'settings' => array(
				'responsive' => array(
					'tablet'  => 991,
					'desktop' => 1199,
				),
				'control'    => array(
					'selectors' => array(
						'body.single .boldgrid-section > .container-fluid',
						'body.single .boldgrid-section > .full-width',
						'body.single .page-header-wrapper.full-width .featured-imgage-header:not( .container )',
					),
					'title'     => 'Container Max Width',
					'name'      => 'bgtfw_blog_posts_container_max_width',
					'sliders'   => array(
						array(
							'name'        => 'maxWidth',
							'label'       => '',
							'cssProperty' => 'max-width',
						),
					),
					'units'     => array(
						'default' => 'px',
						'enabled' => array( 'px' ),
					),
				),
			),
		),
	),
	'bgtfw_woocommerce_container_max_width'      => array(
		'type'              => 'kirki-generic',
		'transport'         => 'postMessage',
		'section'           => 'bgtfw_layout_woocommerce_container',
		'settings'          => 'bgtfw_woocommerce_container_max_width',
		'label'             => 'Container Max Width',
		'default'           => $bgtfw_generic->get_width_defaults( 'max-width' ),
		'priority'          => 40,
		'sanitize_callback' => array( 'Boldgrid_Framework_Customizer_Generic', 'sanitize' ),
		'active_callback'   => array(
			array(
				'setting'  => 'bgtfw_woocommerce_container',
				'operator' => '===',
				'value'    => 'max-full-width',
			),
		),
		'choices'           => array(
			'name'     => 'boldgrid_controls',
			'type'     => 'ContainerWidth',
			'settings' => array(
				'responsive' => array(
					'tablet'  => 991,
					'desktop' => 1199,
				),
				'control'    => array(
					'selectors' => array(
						'body.woocommerce .container-fluid',
						'body.woocommerce .boldgrid-section > .full-width',
						'body.woocommerce #main-wrapper.full-width.max-full-width',
						'body.woocommerce .page-header-wrapper.full-width .featured-imgage-header:not( .container )',
					),
					'title'     => 'Container Max Width',
					'name'      => 'woocommerce_container_max_width',
					'sliders'   => array(
						array(
							'name'        => 'maxWidth',
							'label'       => '',
							'cssProperty' => 'max-width',
						),
					),
					'units'     => array(
						'default' => 'px',
						'enabled' => array( 'px' ),
					),
				),
			),
		),
	),
);
