<?php

namespace fortressdb;

class Logger {
    const LEVEL_INFO = 'INFO';
    const LEVEL_ERROR = 'ERROR';
    const LEVEL_DEBUG = 'DEBUG';

    static private function is_object_type( &$value ) {
        return in_array( gettype( $value ), array('array', 'object') );
    }

    static function log($title, $message = '', $level = Logger::LEVEL_INFO) {
        $timestamp = date( 'c' );

        if ( $title && Logger::is_object_type( $title ) ) {
            $title = json_encode( $title, JSON_PRETTY_PRINT );
        }
        if ( $message ) {
            if ( Logger::is_object_type( $message ) ) {
                $message = json_encode( $message, JSON_PRETTY_PRINT );
            }
            $message = "\n{$message}";
        }
        \file_put_contents(
            'php://stdout',
            "[{$timestamp}][{$level}]\n" .
            $title . $message .
            "\n----------------------------------------\n",
            FILE_APPEND
        );
    }

    static function info($title, $message = '') {
        Logger::log($title, $message, Logger::LEVEL_INFO);
    }

    static function error($title, $message = '') {
        Logger::log($title, $message, Logger::LEVEL_ERROR);
    }

    static function debug($title, $message = '') {
        Logger::log($title, $message, Logger::LEVEL_DEBUG);
    }
}